#ifndef GAUGE_V_GAUGE_H_
#define GAUGE_V_GAUGE_H_

#include "Gauge.h"
#include "Gauge_Type.h"


/**
 *  @brief      initialize  VGauge algorithm
 *  @param[in]  pBattGlobalParams        Pointer to the global battery parameters
 */
void VGauge_Init(tBattGlobalParams *pBattGlobalParams);

/**
 *  @brief      VGauge algorithm running
 *  @param[in]  pBattGlobalParams        Pointer to the global battery parameters
 */
void VGauge_Handler(tBattGlobalParams *pBattGlobalParams);

/**
 *  @brief      Calculate the middle value using liner relationship in IQ15 type
 *             X1,X2 and Y1, Y2 is the range, we want to calculate Y related to X
 *
 *  @param[in]  X
 *  @param[in]  X1
 *  @param[in]  X2
 *  @param[in]  Y1
 *  @param[in]  Y2
 *
 *  @param[out] Y
 *
 *  NOTE: Need to avoid X2 equal to X1
 */
_iq15 VGauge_IQ15CalMidNum(_iq15 X,_iq15 X1,_iq15 X2,_iq15 Y1,_iq15 Y2);

/**
 *  @brief      Search the OCV value related to the SOC input
 *
 *  @param[in]  iq15Soc            SOC input search
 *  @param[in]  u8TableLength      The length of battery circuit table
 *  @param[in]  pCircuitTable       A pointer to the battery circuit table
 *
 *  @param[out] OCV                searched OCV
 *
 *  NOTE: Need to avoid X2 equal to X1
 */
uint16_t VGuage_BattOcvSerach(_iq15 iq15Soc,
                             uint8_t u8TableLength,
                             tBattCircuitParams *pCircuitTable);

/**
 *  @brief      Search the SOC value related to the OCV input
 *
 *  @param[in]  u16Ocv             OCV input search
 *  @param[in]  u8TableLength      The length of battery circuit table
 *  @param[in]  pCircuitTable       A pointer to the battery circuit table
 *
 *  @param[out] SOC                searched SOC
 *
 *  NOTE: Need to avoid X2 equal to X1
 */
_iq15 VGuage_BattSocSerach(uint16_t u16Ocv,
                           uint8_t u8TableLength,
                           tBattCircuitParams *pCircuitTable);

#endif /* GAUGE_V_GAUGE_H_ */
